/** @file   menunotification.h
 * @brief   Declaraction of MenuNotification - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_MENU_NOTIFICATION_H
#define H_WWW_MENU_NOTIFICATION_H

#include "menupage.h"
#include "Font.h"
#include <string>


namespace WeWantWar {


/** @class  MenuNotification
 * @brief   A menupage that can show short messages.
 * @author  Tomi Lamminsaari
 *
 * This class represents a menupage that we use when showing error messages.
 * It has also a redirecting information so that we can go to right menupage
 * after the user closes this page.
 *
 * Notification-window can have a caption and 2 lines of text.
 */
class MenuNotification : public MenuPage
{
public:

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs new empty notification page.
   */
  MenuNotification( );
  
  /** Constructs new notification window.
   * @param     caption           The caption text. This will be printed
   *                              to the top of this window with different
   *                              color.
   * @param     line1             The first line of the message.
   */
  MenuNotification( const std::string& caption, const std::string& line1 );
  
  /** Constructs new notification window.
   * @param     caption           The caption text. This will be printed
   *                              to the top of this window with different
   *                              color.
   * @param     line1             The first line of the message.
   * @param     line2             The second line of the message.
   */
  MenuNotification( const std::string& caption, const std::string& line1,
                    const std::string& line2 );
                    
  /** Destructor.
   */
  virtual ~MenuNotification();



  ///
  /// Public methods
  /// ==============
  
  /** Reimplemented update-method. See MenuPage - class for more information.
   */
  virtual int update();
  
  /** Reimplemented redraw-method. See MenuPage - class for more information.
   */
  virtual void redraw();
  
  /** Sets the page that should be shown after this page.
   * @param     gotoPage          ID of the next page.
   */
  void setGotoPage( MenuPage::PageID gotoPage );
  
  /** Sets the caption.
   * @param     caption           The caption text.
   */
  void setCaption( const std::string& caption );
  
  /** Sets the first message line.
   * @param     line1             The first line of the message.
   */
  void setLine1( const std::string& line1 );
  
  /** Sets the second message line.
   * @param     line2             The second line of the message.
   */
  void setLine2( const std::string& line2 );



  ///
  /// Getter methods
  /// ==============

  /** Returns the ID of this page.
   * @return    ID of this page.
   */
  virtual MenuPage::PageID getPageID() const { return MenuPage::NOTIFICATION; }
  
  /** Returns the ID of the page that should be shown after this page.
   * @return    ID of the page that should be shown after this page.
   */
  MenuPage::PageID getGotoPage() const;
  
  
protected:

  ///
  /// Members
  /// =======

  /** The page that should be shown after this page */
  MenuPage::PageID  m_gotoPage;
  /** The caption text. */
  std::string m_caption;
  /** The first line of the message */
  std::string m_line1;
  /** The second line of the message */
  std::string m_line2;

private:

  /** Private methods **/

  MenuNotification(const MenuNotification& rO);
  MenuNotification& operator = (const MenuNotification& rO);
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: menunotification.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:03+02  lamminsa
 * Initial revision
 *
 */
 
